-------------------------------------------------------------------------------------------------------------------
-- REVISION 6 LUA Scripts (Ov3rHell3XoduZ)
-- Tweaked LUA Script used from SIMPLY LOVE PORT.
-------------------------------------------------------------------------------------------------------------------
function CreateFile(fileName, fileType, strToWrite, fileDir)
	local f = RageFileUtil.CreateRageFile()
	
	fileName = fileName or "NewFile"
	fileType = fileType or ".cfg"
	strToWrite = strToWrite or "Blank"
	fileDir = fileDir or ""

	f:Open((THEME:GetCurrentThemeDirectory().."/Other/"..fileDir.."/"..fileName..fileType):gsub("new",""),2)
	f:Write(strToWrite)
	f:Close()
	f:destroy()
end

function WriteFile(fileName, strToWrite, fileDir)
	local f = RageFileUtil.CreateRageFile()
	local FileExist = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/"..fileDir.."/"..fileName)
	
	fileName = fileName or "NewFile.cfg"
	strToWrite = strToWrite or "Blank"
	fileDir = fileDir or ""
	
	if FileExist then
		f:Open((THEME:GetCurrentThemeDirectory().."Other/"..fileDir.."/"..fileName):gsub("new",""),2)
		f:Write(strToWrite)
		f:Close()
		f:destroy()
	else
		assert(FileExist,"The file "..fileName.." doesn't exist on "..fileDir..". Unable to write file.")
	end
end

function LoadFile(fileName, fileDir)
	local f = RageFileUtil.CreateRageFile()
	local FileExist = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/"..fileDir.."/"..fileName)
	local text
	
	fileName = fileName or "NewFile"
	fileDir = fileDir or ""
	
	if FileExist then
		f:Open((THEME:GetCurrentThemeDirectory().."Other/"..fileDir.."/"..fileName):gsub("new",""),1)
		text = f:Read()
		f:Close()
		f:destroy()
	else
		text = nil
		assert(FileExist,"The file "..fileName.." doesn't exist on "..fileDir..". Unable to load file.")
	end
	
	return text
end

function InitSettings()
	-- Per Profile Settings
	local ProfileName = PROFILEMAN:GetLocalProfileDisplayNames()
	if PROFILEMAN:GetNumLocalProfiles() == 0 then
		for i = 1,16 do
			local GenericSlots = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/ThemeSlots Generic/ThemeSlot"..i..".cfg")
			if not GenericSlots then CreateFile("ThemeSlot"..i,".cfg","EMPTY","Settings/ThemeSlots Generic") end
		end
	else
		for p = 1,PROFILEMAN:GetNumLocalProfiles() do
			for i = 1,16 do
				local ThemeSlots = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/ThemeSlots "..ProfileName[p].."/ThemeSlot"..i..".cfg")
				if not ThemeSlots then CreateFile("ThemeSlot"..i,".cfg","EMPTY","Settings/ThemeSlots "..ProfileName[p]) end
			end
		end
		for p = 1,PROFILEMAN:GetNumLocalProfiles() do
			for i = 1,60 do
				local Ach = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Unlocks/Achievements "..ProfileName[p].."/"..i..".cfg")
				if not Ach then CreateFile(i,".cfg","????","Unlocks/Achievements "..ProfileName[p]) end
			end
		end
	end
	
	for i = 1,72 do
		local eggs = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Unlocks/Easter Eggs/"..i..".cfg")
		if not eggs then CreateFile(i,".cfg","????","Unlocks/Easter Eggs") end
	end
	
	-- Files to Check
	local InitFile = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/InitFile.cfg")
	local MouseInput = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/MouseInput.cfg")
	local ThemeColor = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/ThemeColor.cfg")
	local TimerType = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/TimerType.cfg")
	local TimerCountdown = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/TimerCountdown.cfg")
	local TimerNormal = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/TimerNormal.cfg")
	local CommifyComboP1 = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/CommifyComboP1.cfg")
	local CommifyComboP2 = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/CommifyComboP2.cfg")
	local DebugMode = FILEMAN:DoesFileExist(THEME:GetCurrentThemeDirectory().."Other/Settings/DebugMode.cfg")
	
	-- Creates files only if them don't exist. Required to prevent rewrites existing files.
	if not InitFile then CreateFile("InitFile",".cfg","Init Settings has been created succesfully!","Settings") end
	if not MouseInput then CreateFile("MouseInput",".cfg","Disabled","Settings") end
	if not ThemeColor then CreateFile("ThemeColor",".cfg","#062B62","Settings") end
	if not TimerType then CreateFile("TimerType",".cfg","Timer","Settings") end
	if not TimerCountdown then CreateFile("TimerCountdown",".cfg",1801,"Settings") end
	if not TimerNormal then CreateFile("TimerNormal",".cfg",91,"Settings") end
	if not CommifyComboP1 then CreateFile("CommifyComboP1",".cfg","On","Settings") end
	if not CommifyComboP2 then CreateFile("CommifyComboP2",".cfg","On","Settings") end
	if not DebugMode then CreateFile("DebugMode",".cfg","Off","Settings") end
end

-------------------------------------------------------------------------------------------------------------------
-- SIMPLY LOVE FUNCTION (Thanks dbk2).
-------------------------------------------------------------------------------------------------------------------
function FindInTable(needle, haystack)
	for i = 1, #haystack do
		if needle == haystack[i] then
			return i
		end
	end
	return nil
end

function tableContains(table,key)
	return (table[key] ~= nil)
end

local PlayerDefaults = {
	__index = {
		initialize = function(self)
			self.ActiveModifiers = {
				LifeVisible = "Enable",
				PlayerStats = "On",
				Vocalization = "None",
				NPS = "On",
				GraphDisplay = "On",
				MeasureCounter = "None",
				SubtractiveScoring = "On",
				ColumnFlashed = "Off",
				ScreenFilter = nil,
				PlayerOptions = "NOT SAVED SLOT LOADED"
			}
			self.Streams = {
				SongDir = nil,
				StepsType = nil,
				Difficulty = nil,
				Measures = nil,
			}
			self.Stages = {
				Stats = {}
			}
		end
	}
}

local GlobalDefaults = {
	__index = {
		initialize = function(self)
			self.Stages = {
				PlayedThisGame = 0,
				Remaining = PREFSMAN:GetPreference("SongsPerPlay"),
				MusicRate = {},
				Stats = {}
			}
			self.ScreenAfter = {
				PlayerOptions = "ScreenGameplay",
				PlayerOptions2 = "ScreenGameplay",
				PlayerOptions3 = "ScreenGameplay",
				JukeboxMenu = "ScreenJukebox"
			}
			self.PlayedRateMods = {
				-- It will start as a empty table.
			}
			self.Achievements = {
				Player = nil,
			}
			self.ModPanel = {
				Player = nil,
				RateType = nil,
				RateMaxValue = 2.5,
				SpeedMod = nil,
				SpeedMaxValue = nil,
				NoteSizeMaxValue = 150,
			}
			self.MiscOptions = {
				AutoRestartWithButton = "Off",
				RateModUsed = "1.0",
				TimerCountDownStart = tonumber(LoadFile("TimerCountdown.cfg","Settings")),
				TimerCountDownContainer = 0,
				TimerNormalStart = LoadFile("TimerNormal.cfg","Settings"),
				GameChangedFromOpList = false,
			}
		end
	}
}

MetroQuad = {
	P1 = setmetatable( {}, PlayerDefaults),
	P2 = setmetatable( {}, PlayerDefaults),
	Global = setmetatable( {}, GlobalDefaults),
}

function InitializeMetroQuad()
	MetroQuad.P1:initialize()
	MetroQuad.P2:initialize()
	MetroQuad.Global:initialize()
end

InitializeMetroQuad()